<?php

namespace App\Models\Commandes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Commande extends Model 
{

    protected $table = 'commandes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function trajet()
    {
        return $this->belongsTo('App\Models\Trajet\Trajet');
    }

    public function payement()
    {
        return $this->belongsTo('App\Models\Payement\Payement');
    }

    public function tarif()
    {
        return $this->belongsTo('App\Models\Tarif\Tarif');
    }

    public function client()
    {
        return $this->belongsTo('App\Models\Client\Client');
    }

}